package easik.sketch.util.Export.Text;

import java.util.ArrayList;
import java.util.LinkedList;

import javax.swing.JOptionPane;

import easik.sketch.util.Export.ExportConstants;
import easik.sketch.util.Export.ExportHandler;
import easik.sketch.util.Export.SketchToSchema;


/**
 * A class to create strings for addition to an SQL text file.
 * Accepts a SQLFileBuilder and an ExportHandler associated with the current sketch.
 * Formats strings generated in a SketchToSchema object for writing to a text file.  These strings 
 * are then given to the SQLFileBuilder object to be written to the user defined file.
 * 
 * @author Vera Ranieri
 * @since 2006-05-17 Vera Ranieri
 * @version 2006-06-19 Vera Ranieri
 */
public class TextBuilder {
	/**
	 * The file builder containing the file to be written to
	 */
	private SQLFileBuilder _fb;
	/**
	 * The object containing the sketch data, prepared for SQL
	 */
	private SketchToSchema _schema;
	
	/**
	 * The new line string for this system
	 */
	private String _sep = System.getProperty("line.separator");
	
	/**
	 * Constructor.  
	 * 
	 * @param fileBuilder The SQLFileBuilder object associated with this schema
	 * @param sh The ExportHandler associated with this schema.
	 * @param name The name of the new database
	 * @since 2006-06-19 Vera Ranieri
	 */
	public TextBuilder(SQLFileBuilder fileBuilder, ExportHandler sh, String name){

		_fb = fileBuilder;
		
		_schema = new SketchToSchema(sh, name);
		//Add "CREATE DATABASE ..." string
		addStringToFile(_schema.getCreateString() + _sep);
		
		//Add "USE ... " string
		addStringToFile(_schema.getUseString() + _sep);
			
		addTables();
		
		addConstraints();
		
		addTriggers();
		
		
	}
	
	/**
	 * Formats tables for SQL.  This includes the addition of a <b>fail</b> table.  Once tables are formatted, they are
	 * added to the file
	 * 
	 * @since 2006-06-19 Vera Ranieri
	 */
	private void addTables(){
//		Add tables
		LinkedList tables = _schema.getTables();
		
		int size = tables.size();
		String addTable;
	
		for(int i=0; i< size; i++){
			addTable = (String)tables.get(i) + _sep;
			addStringToFile(addTable);
			
		}
		
		addStringToFile(ExportConstants.FAIL_TABLE);
	}
	/**
	 * Formats constraints for SQL.  This formatting includes changing the SQL delimiter before and after the creation of the 
	 * constraint.  Once strings are formatted, they are then added to the file.
	 *
	 * @since 2006-06-19 Vera Ranieri
	 */
	private void addConstraints(){
		//Add Procedures
		ArrayList constraints = _schema.getConstraints();
		if(constraints != null){
			int size = constraints.size();
			String writeStr = ExportConstants.DELIMITER$;
			addStringToFile(writeStr);
			
			for(int j = 0; j< size ; j++){
				writeStr = (String)constraints.get(j);
				writeStr = writeStr.substring(0, writeStr.length()-3) + "$$ " + _sep;
				addStringToFile(writeStr);
			}
			
			writeStr = ExportConstants.FAIL_PROC;
			writeStr = writeStr.substring(0, writeStr.length()-3) + "$$ " +_sep;
			addStringToFile(writeStr);
			
			addStringToFile(ExportConstants.DELIMITER);
		}
	}
	
	/**
	 * Formats triggers for SQL.  Once triggers are formatted, they are added to the file
	 * 
	 * @since 2006-06-19 Vera Ranieri
	 *
	 */
	private void addTriggers(){
		ArrayList triggers = _schema.getTriggers();
		if(triggers != null){
			
			addStringToFile(ExportConstants.DELIMITER$);
			
			String writeStr;
			
			int size = triggers.size();
			for(int i = 0; i< size; i++){
				writeStr = (String)triggers.get(i);
				writeStr = writeStr.substring(0, writeStr.length()-3) + "$$ " + _sep;
				addStringToFile(writeStr);
			}
			
			addStringToFile(ExportConstants.DELIMITER);
		}
	}
	
	/**
	 * Writes a string to the file stored in the SQLFileBuilder passed to the constructor.
	 * 
	 * @param s The string to write to the file
	 */
	private void addStringToFile(String s){
		if(!_fb.writeToFile(s)){
			JOptionPane.showMessageDialog(null,"Error Writing SQL text to file" , 
					"Error",JOptionPane.ERROR_MESSAGE);
		}
	}

}
